// $Id: CFont.cpp,v 1.7 2007/03/07 22:18:51 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CFont.hpp"
using Exponent::GUI::Fonts::CFont;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CFont, CCountedObject);

//	===========================================================================
CFont *CFont::CFONT_SYSTEM_FONT = NULL;

//	===========================================================================
CFont::CFont(const CString &fontName, const unsigned long height) 
	 : m_fontName(fontName)
	 , m_height(height)
#ifdef WIN32
	 , m_fontHandle(NULL)
#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CFont);

	m_height   = height;
	m_fontName = fontName;
#ifdef WIN32
	m_logFont.lfHeight			= -CFont::getFontSizeFromPointSize(height);//-CWindowTools::computeLogicalSizeFromPointSize(height);
	m_logFont.lfWidth			= 0;
	m_logFont.lfEscapement		= 0;
	m_logFont.lfOrientation		= 0;
	m_logFont.lfWeight			= FW_NORMAL;
	m_logFont.lfItalic			= FALSE;
	m_logFont.lfUnderline		= FALSE;
	m_logFont.lfStrikeOut		= FALSE;
	m_logFont.lfCharSet			= ANSI_CHARSET;
	m_logFont.lfOutPrecision	= OUT_TT_PRECIS;
	m_logFont.lfClipPrecision	= CLIP_DEFAULT_PRECIS;
	m_logFont.lfQuality			= CLEARTYPE_QUALITY;//ANTIALIASED_QUALITY;//DEFAULT_QUALITY;
	m_logFont.lfPitchAndFamily	= DEFAULT_PITCH | FF_DONTCARE;
	_tcsncpy(m_logFont.lfFaceName, _T(fontName.getString()), LF_FACESIZE - 1);	
	this->loadFont();
#endif
}

//	===========================================================================
CFont::CFont(const CFont &font)
	 : m_fontName(font.m_fontName)
	 , m_height(font.m_height)
#ifdef WIN32
	 , m_fontHandle(NULL)
#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CFont);
	
	m_height   = font.m_height;
	m_fontName = font.m_fontName;
#ifdef WIN32
	m_logFont.lfHeight			= font.m_logFont.lfHeight;
	m_logFont.lfWidth			= font.m_logFont.lfWidth;
	m_logFont.lfEscapement		= font.m_logFont.lfEscapement;
	m_logFont.lfOrientation		= font.m_logFont.lfOrientation;
	m_logFont.lfWeight			= font.m_logFont.lfWeight;
	m_logFont.lfItalic			= font.m_logFont.lfItalic;
	m_logFont.lfUnderline		= font.m_logFont.lfUnderline;
	m_logFont.lfStrikeOut		= font.m_logFont.lfStrikeOut;
	m_logFont.lfCharSet			= font.m_logFont.lfCharSet;
	m_logFont.lfOutPrecision	= font.m_logFont.lfOutPrecision;
	m_logFont.lfClipPrecision	= font.m_logFont.lfClipPrecision;
	m_logFont.lfQuality			= font.m_logFont.lfQuality;
	m_logFont.lfPitchAndFamily	= font.m_logFont.lfPitchAndFamily;
	strcpy(m_logFont.lfFaceName, font.m_logFont.lfFaceName);
	this->loadFont();
#endif
}

//	===========================================================================
CFont::~CFont()
{
	EXPONENT_CLASS_DESTRUCTION(CFont);
	this->unloadFont();
}

//	===========================================================================
CFont &CFont::operator = (const CFont &font)
{
	this->unloadFont();

	m_fontName = font.getFontName();
	m_height   = font.getHeight();
	
#ifdef WIN32
	m_logFont.lfHeight			= font.m_logFont.lfHeight;
	m_logFont.lfWidth			= font.m_logFont.lfWidth;
	m_logFont.lfEscapement		= font.m_logFont.lfEscapement;
	m_logFont.lfOrientation		= font.m_logFont.lfOrientation;
	m_logFont.lfWeight			= font.m_logFont.lfWeight;
	m_logFont.lfItalic			= font.m_logFont.lfItalic;
	m_logFont.lfUnderline		= font.m_logFont.lfUnderline;
	m_logFont.lfStrikeOut		= font.m_logFont.lfStrikeOut;
	m_logFont.lfCharSet			= font.m_logFont.lfCharSet;
	m_logFont.lfOutPrecision	= font.m_logFont.lfOutPrecision;
	m_logFont.lfClipPrecision	= font.m_logFont.lfClipPrecision;
	m_logFont.lfQuality			= font.m_logFont.lfQuality;
	m_logFont.lfPitchAndFamily	= font.m_logFont.lfPitchAndFamily;
	strcpy(m_logFont.lfFaceName, font.m_logFont.lfFaceName);
#endif
	this->loadFont();
	return (*this);
}

//	===========================================================================
void CFont::setFont(const CFontReference &font)
{
	this->unloadFont();
	m_fontName = font.getName();
#ifdef WIN32
	_tcsncpy(m_logFont.lfFaceName, _T(font.getName().getString()), LF_FACESIZE - 1);
	this->loadFont();
#endif
}

//	===========================================================================
void CFont::setFont(const CString &fontName, const long height, const bool italic, const bool underline, const bool strike, const bool bold)
{
	this->unloadFont();
	m_fontName = fontName;
	m_height   = height;
	
#ifdef WIN32
	m_logFont.lfHeight			= -CFont::getFontSizeFromPointSize(height);//-CWindowTools::computeLogicalSizeFromPointSize(height);
	m_logFont.lfWidth			= 0;
	m_logFont.lfEscapement		= 0;
	m_logFont.lfOrientation		= 0;
	m_logFont.lfWeight			= (bold)      ? FW_BOLD : FW_NORMAL;
	m_logFont.lfItalic			= (italic)    ? TRUE    : FALSE;
	m_logFont.lfUnderline		= (underline) ? TRUE    : FALSE;
	m_logFont.lfStrikeOut		= (strike)    ? TRUE    : FALSE;
	m_logFont.lfCharSet			= ANSI_CHARSET;
	m_logFont.lfOutPrecision	= OUT_TT_PRECIS;
	m_logFont.lfClipPrecision	= CLIP_DEFAULT_PRECIS;
	m_logFont.lfQuality			= CLEARTYPE_QUALITY;//ANTIALIASED_QUALITY;//DEFAULT_QUALITY;
	m_logFont.lfPitchAndFamily	= DEFAULT_PITCH | FF_DONTCARE;
	_tcsncpy(m_logFont.lfFaceName, _T(fontName.getString()), LF_FACESIZE - 1);
	this->loadFont();
#endif
}

//	===========================================================================
void CFont::setHeight(const unsigned long height)
{
	this->unloadFont();
	m_height = height;
#ifdef WIN32
	m_logFont.lfHeight = -CFont::getFontSizeFromPointSize(height);//-CWindowTools::computeLogicalSizeFromPointSize(height);
	this->loadFont();
#endif
}

//	===========================================================================
void CFont::setFontName(const CString &fontname)
{
	this->unloadFont();
	m_fontName = fontname;
#ifdef WIN32
	_tcsncpy(m_logFont.lfFaceName, _T(fontname.getString()), LF_FACESIZE - 1);
	this->loadFont();
#endif
}

//	===========================================================================
void CFont::loadFont()
{
#ifdef WIN32
	m_fontHandle = CreateFontIndirect(&m_logFont);
#endif
}

//	===========================================================================
void CFont::unloadFont()
{
#ifdef WIN32
	if (m_fontHandle)
	{
		DeleteObject(m_fontHandle);
	}
	NULL_POINTER(m_fontHandle);
#endif
}

//	===========================================================================
long CFont::getWidth() const
{
#ifdef WIN32
	return m_logFont.lfWidth;
#else
	return m_height;	// Not actually correct...
#endif
}

//	===========================================================================
long CFont::getHeight() const
{
#ifdef WIN32
	return m_logFont.lfHeight;
#else
	return m_height;
#endif
}

//	===========================================================================
long CFont::getFontSize() const
{
	return m_height;
}

//	===========================================================================
long CFont::getStringLength(const CString &string, void *drawContext)
{
#ifdef WIN32
	SIZE size;
	if (GetTextExtentPoint32((HDC)drawContext, string.getString(), string.getNumberOfCharacters() - 1, &size) == TRUE)
	{
		return size.cx;
	}
	return 0;
#else
	return TextWidth(string.getString(), 0, strlen(string.getString()));
#endif
}

//	===========================================================================
void CFont::createDefaultFont()
{
#ifdef WIN32
	const unsigned long size = 8;
#else
	const unsigned long size = 9;
#endif	
	CFONT_SYSTEM_FONT = new CFont("Arial", size);
	CFONT_SYSTEM_FONT->referenced();
}

//	===========================================================================
void CFont::destroyDefaultFont()
{
	FORGET_COUNTED_OBJECT(CFONT_SYSTEM_FONT);
}

//	===========================================================================
long CFont::getFontSizeFromPointSize(const long pointSize)
{
#ifdef WIN32
	HDC dc = GetDC(NULL);
	long size = MulDiv(pointSize, GetDeviceCaps(dc, LOGPIXELSY), 72);
	ReleaseDC(NULL, dc);
	return size;
#else
	return pointSize;
#endif
}

